/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.heroku.internal.ui;

import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ExecutableUtil;
import com.aptana.core.util.ProcessUtil;
import com.aptana.deploy.heroku.HerokuPlugin;
import com.aptana.deploy.heroku.internal.ui.Messages;
import com.aptana.deploy.ui.DeployContributionItem;
import com.aptana.ui.util.UIUtils;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class HerokuContributionItem
extends DeployContributionItem {
    private static final String BUNDLE_HEROKU = "Heroku";

    public HerokuContributionItem() {
    }

    public HerokuContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        IResource selectedResource = UIUtils.getSelectedResource();
        if (selectedResource == null) {
            return;
        }
        final IProject selectedProject = selectedResource.getProject();
        MenuItem item = new MenuItem(menu, 8);
        item.setText(Messages.HerokuContributionItem_OpenBrowserItem);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath workingDir = selectedProject.getLocation();
                Map env = null;
                if (!"win32".equals(Platform.getOS())) {
                    env = ShellExecutable.getEnvironment((IPath)workingDir);
                }
                IPath herokuPath = ExecutableUtil.find((String)"heroku", (boolean)true, null);
                String output = ProcessUtil.outputForCommand((String)herokuPath.toOSString(), (IPath)workingDir, (Map)env, (String[])new String[]{"info"});
                try {
                    if (output != null && output.contains("Web URL:")) {
                        String URL2 = output.split("Web URL:")[1].split("\n")[0].replace(" ", "");
                        if ("macosx".equals(Platform.getOS())) {
                            ProcessUtil.run((String)"open", null, null, (String[])new String[]{URL2});
                        } else if ("win32".equals(Platform.getOS())) {
                            ProcessUtil.run((String)"cmd", null, null, (String[])new String[]{"/c", "start " + URL2});
                        } else {
                            ProcessUtil.run((String)"x-www-browser", null, null, (String[])new String[]{URL2});
                        }
                    }
                }
                catch (Exception e1) {
                    IdeLog.logError((Plugin)HerokuPlugin.getDefault(), (Throwable)e1);
                }
            }
        });
        MenuItem sharingMenuItem = new MenuItem(menu, 64);
        sharingMenuItem.setText(Messages.HerokuContributionItem_SharingSubmenuLabel);
        Menu sharingSubMenu = new Menu(menu);
        HerokuContributionItem.createDeploySubMenuItem((Menu)sharingSubMenu, (String)"Add Collaborator", (String)BUNDLE_HEROKU);
        HerokuContributionItem.createDeploySubMenuItem((Menu)sharingSubMenu, (String)"Remove Collaborator", (String)BUNDLE_HEROKU);
        sharingMenuItem.setMenu(sharingSubMenu);
        MenuItem databaseMenuItem = new MenuItem(menu, 64);
        databaseMenuItem.setText(Messages.HerokuContributionItem_DatabaseSubmenuLabel);
        Menu databaseSubMenu = new Menu(menu);
        HerokuContributionItem.createDeploySubMenuItem((Menu)databaseSubMenu, (String)"Rake db:migrate on Heroku", (String)BUNDLE_HEROKU);
        HerokuContributionItem.createDeploySubMenuItem((Menu)databaseSubMenu, (String)"Push Local Database to Heroku", (String)BUNDLE_HEROKU);
        HerokuContributionItem.createDeploySubMenuItem((Menu)databaseSubMenu, (String)"Pull Remote Database from Heroku", (String)BUNDLE_HEROKU);
        databaseMenuItem.setMenu(databaseSubMenu);
        MenuItem maintenanceMenuItem = new MenuItem(menu, 64);
        maintenanceMenuItem.setText(Messages.HerokuContributionItem_MaintenanceSubmenuLabel);
        Menu maintanenceSubMenu = new Menu(menu);
        HerokuContributionItem.createDeploySubMenuItem((Menu)maintanenceSubMenu, (String)"Turn Maintence On", (String)BUNDLE_HEROKU);
        HerokuContributionItem.createDeploySubMenuItem((Menu)maintanenceSubMenu, (String)"Turn Maintence Off", (String)BUNDLE_HEROKU);
        maintenanceMenuItem.setMenu(maintanenceSubMenu);
        MenuItem remoteMenuItem = new MenuItem(menu, 64);
        remoteMenuItem.setText(Messages.HerokuContributionItem_RemoteSubmenuLabel);
        Menu remoteSubMenu = new Menu(menu);
        HerokuContributionItem.createDeploySubMenuItem((Menu)remoteSubMenu, (String)"Console", (String)BUNDLE_HEROKU);
        HerokuContributionItem.createDeploySubMenuItem((Menu)remoteSubMenu, (String)"Rake Command", (String)BUNDLE_HEROKU);
        remoteMenuItem.setMenu(remoteSubMenu);
        MenuItem configMenuItem = new MenuItem(menu, 64);
        configMenuItem.setText(Messages.HerokuContributionItem_ConfigVarsSubmenuLabel);
        Menu configSubMenu = new Menu(menu);
        HerokuContributionItem.createDeploySubMenuItem((Menu)configSubMenu, (String)"Add Config Var", (String)BUNDLE_HEROKU);
        HerokuContributionItem.createDeploySubMenuItem((Menu)configSubMenu, (String)"Clear Config Vars", (String)BUNDLE_HEROKU);
        configMenuItem.setMenu(configSubMenu);
        HerokuContributionItem.createDeploySubMenuItem((Menu)menu, (String)"App Info", (String)BUNDLE_HEROKU);
        HerokuContributionItem.createDeploySubMenuItem((Menu)menu, (String)"Rename App", (String)BUNDLE_HEROKU);
    }
}

